<?php
/**
 * @package     Tracks.library
 * @subpackage  Entity
 * @copyright   Tracks (C) 2008-2015 Julien Vonthron. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

/**
 * Participant Entity.
 *
 * @property int  $id
 * @property int  $name
 * @property int  $short_name
 *
 * @since  __deploy_version__
 */
class TrackslibEntityParticipant_role extends TrackslibEntityBase
{
	/**
	 * Override name
	 *
	 * @param   string  $name  table name
	 *
	 * @return JTable|RTable
	 */
	protected function getTable($name = null)
	{
		if (null === $name)
		{
			$name = "Participants_roles";
		}

		$name = str_replace('Entity', '', $name);

		return RTable::getAdminInstance($name, array(), $this->getComponent());
	}
}
