<?php
/**
 * @package     Tracks
 * @subpackage  Admin
 * @copyright   Tracks (C) 2008-2015 Julien Vonthron. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die('Restricted access');

/**
 * HTML View class for Tracks participants
 *
 * @package     Tracks
 * @subpackage  Admin
 * @since       3.0
 */
class TracksViewParticipants extends TrackslibViewAdmin
{
	/**
	 * Execute and display a template script.
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  mixed  A string if successful, otherwise a Error object.
	 */
	public function display($tpl = null)
	{
		$user = JFactory::getUser();

		$this->items = $this->get('Items');
		$this->pagination = $this->get('Pagination');
		$this->filterForm = $this->get('Form');
		$this->activeFilters = $this->get('ActiveFilters');
		$this->state = $this->get('State');

		$projectsModel = Tracks\Model\ModelAdmin::getInstance('projects');
		$projectsModel->setState('list.limit', 0);
		$projectsModel->setState('list.ordering', 'obj.name');
		$projectsModel->setState('list.direction', 'ASC');
		$this->projectsList = $projectsModel->getItems();

		// Ordering
		$this->ordering = array();

		if ($this->items)
		{
			foreach ($this->items as &$item)
			{
				$this->ordering[0][] = $item->id;
			}
		}

		// Edit permission
		$this->canEdit = false;

		if ($user->authorise('core.edit', 'com_tracks'))
		{
			$this->canEdit = true;
		}

		// Edit state permission
		$this->canEditState = false;

		if ($user->authorise('core.edit.state', 'com_tracks'))
		{
			$this->canEditState = true;
		}

		parent::display($tpl);
	}

	/**
	 * Get the page title
	 *
	 * @return  string  The title to display
	 *
	 * @since   0.9.1
	 */
	public function getTitle()
	{
		return JText::_('COM_TRACKS_PARTICIPANTS');
	}

	/**
	 * Get the tool-bar to render.
	 *
	 * @return  RToolbar
	 */
	public function getToolbar()
	{
		$user = JFactory::getUser();

		$firstGroup = new RToolbarButtonGroup;
		$secondGroup = new RToolbarButtonGroup;
		$thirdGroup = new RToolbarButtonGroup;
		$fourthGroup = new RToolbarButtonGroup;

		if ($user->authorise('core.create', 'com_tracks'))
		{
			$new = RToolbarBuilder::createNewButton('participant.add');
			$firstGroup->addButton($new);
		}

		if ($user->authorise('core.edit', 'com_tracks'))
		{
			$edit = RToolbarBuilder::createEditButton('participant.edit');
			$firstGroup->addButton($edit);
		}

		if ($user->authorise('core.delete', 'com_tracks'))
		{
			$delete = RToolbarBuilder::createDeleteButton('participants.delete');
			$firstGroup->addButton($delete);
		}

		if ($user->authorise('core.edit', 'com_tracks'))
		{
			$button = RToolbarBuilder::createStandardButton(
				'participants.addToAllEvents', JText::_('COM_TRACKS_PARTICIPANTS_ADD_TO_ALL_EVENTS'), '', 'icon-plus', true
			);
			$secondGroup->addButton($button);

			$button = RToolbarBuilder::createModalButton(
				'#importfrom-modal', JText::_('COM_TRACKS_PARTICIPANTS_IMPORT_FROM'), '', 'icon-plus'
			);
			$thirdGroup->addButton($button);
		}

		$this->toolbar = new RToolbar;
		$this->toolbar->addGroup($firstGroup)->addGroup($secondGroup)->addGroup($thirdGroup);

		return parent::getToolbar();
	}
}
