<?php
/**
 * @package     Tracks
 * @subpackage  Library
 * @copyright   Tracks (C) 2008-2017 Julien Vonthron. All rights reserved.
 * @license     GNU General Public License version 2 or later
 */

defined('_JEXEC') or die;

JFormHelper::loadFieldClass('list');

/**
 * Tracks Participant role Field
 *
 * @package     Tracks
 * @subpackage  Library
 * @since       __deploy_version__
 */
class TracksFormFieldParticipant_role extends JFormFieldList
{
	/**
	 * The form field type.
	 *
	 * @var  string
	 */
	public $type = 'participant_role';

	/**
	 * Method to get the field options.
	 *
	 * @return  array  The field option objects.
	 */
	protected function getOptions()
	{
		$db = \JFactory::getDbo();
		$query = $db->getQuery(true)
			->select('id AS value, nama AS label')
			->from('#__tracks_participants_roles')
			->order('ordering ASC');

		$db->setQuery($query);
		$results = $db->loadObjectList();

		$options = array_map(
			function($type)
			{
				return JHtml::_('select.option', $type['name'], $type['label']);
			},
			$results
		);

		return array_merge(parent::getOptions(), $options);
	}
}
